/*

Macro_Scripts File
Created:  29 Mai 2003
Author:   PF Breton

Macro_Scripts that lauches the Advanced Lighting Panel and Assigns the desired plugins if none is used yet


Revision History

	29 Mai 2003, Pierre-Felix Breton created
	
	10 dec 2003, Pierre-Felix Breton, 
               added product switcher: this macroscript file can be shared with all Discreet products



*/


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------------
-- MacroScripts for Lauching the UI
--------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------
-- Radiosity

MacroScript AdvLighting_Radiosity
ButtonText:~ADVLIGHTING_RADIOSITY_CAPTION~
category:~ADVLIGHTING_RADIOSITY_CATEGORY~
internalCategory:"Render"
Tooltip:~ADVLIGHTING_RADIOSITY_TOOLTIP~
Icon:#("Radiosity",1)
(
	on execute do
	(
		local assignAdvLighting= false
		--shows the panel
		sceneradiosity.showpanel()
		
		if classof sceneradiosity.radiosity == Light_Tracer
		then
		(
			local answer
			answer = QueryBox ~QUERYBOX_ADV_LIGHTING_DISCARD~ \
			title:~CHANGE_ADV_LIGHTING_PLUGIN_TITLE~ beep:false
			
			if answer == true do assignAdvLighting= true
		)--end then
		else
		(
			assignAdvLighting= true
		)--end else

		
		if assignAdvLighting == true do
		(
			--assigns a default engine
			if classof sceneradiosity.radiosity != Radiosity do sceneradiosity.radiosity = Discreet_Radiosity()
		
			--assigns a default exposure control
			if (classof sceneExposureControl.exposureControl == UndefinedClass) do 
			(
				local answer
				answer = QueryBox ~QUERYBOX_RADIOSITY_PLUGIN_RECOMMEND_CAMERA_EXP_CONTROL~ \
					title:~ADVLIGHTING_RADIOSITY_QUERY_TITLE~ beep:false
	
				if answer == true do sceneExposureControl.exposureControl = Logarithmic_Exposure_Control()
			)
		)--end if assignAdvLighting == true do

	)
	
	on isenabled return ((classof renderers.current == Default_Scanline_Renderer))
	on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
)



macroScript LightingAnalysis
ButtonText:~BUTTONTEXT_LIGHTING_ANALYSIS~
category:~RENDER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~LIGHTING_ANALYSIS_TOOLTIP~
(

on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
on isEnabled return	((classof sceneradiosity.radiosity == Discreet_Radiosity) and (sceneradiosity.radiosity.CanShowLightingStatistics())) --checks if the lighting analysis tools is available with the engine's current state
On Execute Do
	( 
		Try(sceneradiosity.radiosity.ShowLightingStatistics()) Catch()
	)
)


-------------------------------------------------------------------------------------------------
-- MacroScripts for Quad Controls: Daylight Assemblies
--------------------------------------------------------------------------------------------------
-- store direct illumination of Sunlight located inside a Daylight assembly
macroScript RadProperty_StoreSun
category:~RADPROPERTY_STORESUN_CATEGORY~
internalCategory:"Render"
buttonText:~BUTTONTEXT_STORE_DIRECT_ILLUMINATION_SUN~
Tooltip:~STORE_DIRECT_ILLUMINATION_SUN_TOOLTIP~
( --macroScript RadTool_StoreSun begin

	fn notRadiosExcluded obj =
	(
		((obj.globalIlluminationByLayer and not obj.layer.isGIExcluded) or
		(not obj.globalIlluminationByLayer and not obj.isGIExcluded))
	)
	
	--visibility of menu item
	on isVisible return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
		(
			sunObj = (assemblyMgr.isassembly selection).sun
			if sunObj == undefined then false
				else 
				(
				local sunobj2
				for i in selection do 
					if classof i == IES_Sun or classof i == Directionallight do sunObj2 = i
				if sunObj2 != undefined do notRadiosExcluded sunObj2
				)
				)
	)--end on isvisible
	
	-- status of property					
	on isChecked return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
			if (assemblyMgr.isassembly selection).sun == undefined then false
			else
			(
				sunObj = (assemblyMgr.isassembly selection).sun
				if sunObj == undefined then false
					else 
					(
					local sunobj2
						for i in selection do 
							if classof i == IES_Sun or classof i == Directionallight do sunObj2 = i
						if sunObj2 != undefined do notRadiosExcluded sunObj2 and sunObj2.storeIllumToMesh
					)
			)
	)--end on ischecked
	
	-- execution
	on execute do		
	(
		local sunobj2
		for i in selection do 
			if classof i == IES_Sun or classof i == Directionallight do sunObj2 = i
		sunObj2.globalIlluminationByLayer = false
		sunObj2.storeIllumToMesh = not sunObj2.storeIllumToMesh
	)--end on execute
	
) --macroScript RadTool_StoreSun end



-- store direct illumination of skylight located inside a Daylight assembly
macroScript RadProperty_StoreSky
category:~RADPROPERTY_STORESKY_CATEGORY~
internalCategory:"Render"
buttonText:~BUTTONTEXT_RADPROPERTY_STORESKY~
Tooltip:~RADPROPERTY_STORESKY_TOOLTIP~

( --macroScript RadTool_Storesky begin

	fn notRadiosExcluded obj =
	(
		((obj.globalIlluminationByLayer and not obj.layer.isGIExcluded) or
		(not obj.globalIlluminationByLayer and not obj.isGIExcluded))
	)
	
	--visibility of menu item
	on isVisible return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
		(
			skyObj = (assemblyMgr.isassembly selection).sky
			if skyObj == undefined then false
				else 
				(
				local skyobj2
				for i in selection do 
					if classof i == IES_sky or classof i == Texture_Sky do skyObj2 = i
				if skyObj2 != undefined do notRadiosExcluded skyObj2
				)
				)
	)--end on isvisible
	
	-- status of property					
	on isChecked return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
			if (assemblyMgr.isassembly selection).sky == undefined then false
			else
			(
				skyObj = (assemblyMgr.isassembly selection).sky
				if skyObj == undefined then false
					else 
					(
					local skyobj2
						for i in selection do 
							if classof i == IES_sky or classof i == Texture_Sky do skyObj2 = i
						if skyObj2 != undefined do notRadiosExcluded skyObj2 and skyObj2.storeIllumToMesh
					)
			)
	)--end on ischecked
	
	-- execution
	on execute do		
	(
		local skyobj2
		for i in selection do 
			if classof i == IES_sky or classof i == Texture_Sky do skyObj2 = i
		skyObj2.globalIlluminationByLayer = false
		skyObj2.storeIllumToMesh = not skyObj2.storeIllumToMesh
	)--end on execute
	
) --macroScript RadTool_Storesky end


MacroScript Exposure_Control
ButtonText:~BUTTONTTEXT_EXPOSURE_CONTROL~
category:~EXPOSURE_CONTROL_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~EXPOSURE_CONTROL_TOOLTIP~ 
Icon:#("Exposure",1)
(
	on execute do 
	(	
		actionMan.executeAction 0 "40029" -- LOC NOTE: Do Not Localize this
		
	)
)

--------------------------------------------------------------------------------------------------
-- Light tracer

MacroScript AdvLighting_LightTracer
ButtonText:~BUTTONTEXT_LIGHT_TRACER~
category:~ADVLIGHTING_LIGHTTRACER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~ADVLIGHTING_LIGHTTRACER_TOOLTIP~ 
--Icon:#("Radiosity",1)
(
	on execute do
(
		local assignAdvLighting= false
		--shows the panel
		sceneradiosity.showpanel()
		
		if classof sceneradiosity.radiosity == Radiosity
		then
		(
			local answer
			answer = QueryBox ~ADVLIGHTING_LIGHTTRACER_QUERYBOX_DISCARD_ARE_YOU_SURE~ \
			title:~CHANGE_ADVLIGHTING_LIGHTTRACER_PLUGIN_TITLE~ beep:false
			
			if answer == true do assignAdvLighting= true
		)--end then
		else
		(
			assignAdvLighting= true
		)--end else

		
		if assignAdvLighting == true do
		(
			--assigns a default engine
			if classof sceneradiosity.radiosity != Light_Tracer do sceneradiosity.radiosity = Light_Tracer()

		)--end if assignAdvLighting == true do

	)


	
	on isenabled return ((classof renderers.current == Default_Scanline_Renderer))
	on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB45kUNy46vtAir7akijGgMKshrFBZFYr+s
-- JswyReQvKj9oHKsbQHNTmHQGYfNIHZtim0AnRVDfq0u/QldlwCwW8jNZcBB+rvB8
-- 5in1+M5L+EsczSbTQj4DauBq7fDd+w+F03auek5moGxJZD6CEv+a+jfGd9qLmU4s
-- kOwTuYGAcUNwpdpoIoELtsE4KjJCxUS4utWOdJPxRCCIwWhGi+vvS/jNlBFKxo29
-- e4qTxQnjVYoa6HD8N1qa7Zi9OVWiUE/pjbcBEzO1UGtvmEFx7dWwr3A9ReDRULV9
-- dVRrH6eMJ5MWm7nz/bWJ/sKpQ1UEJ7JbVCXtUL6xCl9IWbjfvWId
-- -----END-SIGNATURE-----